// ParseDlg.cpp : implementation file
//

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include "stdafx.h"
#include "Addr.h"
#include "ParseDlg.h"
#include "Parse.h"
#include "ParseDlg.h"
#include <atlbase.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CParseDlg dialog


CParseDlg::CParseDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CParseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CParseDlg)
	m_Full_Address = _T("");
	m_Range = _T("");
	m_Street = _T("");
	m_Pre_Dir = _T("");
	m_Post_Dir = _T("");
	m_Suffix = _T("");
	m_Suite_Name = _T("");
	m_Suite_Number = _T("");
	m_Build_Number = _T("");
	m_Garbage = _T("");
	m_Last_Line = _T("");
	m_City = _T("");
	m_Plus4 = _T("");
	m_State = _T("");
	m_Zip = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	parse = NULL;
	parseCreated = false;

	//Initialize the COM library
	CoInitialize(0);
}
CParseDlg::~CParseDlg()
{
	//Release the Parse Object
	if (parse)
	{
		parse->Release();
		parse = NULL;
	}
	//Uninitializes the COM library
	CoUninitialize();
}
void CParseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CParseDlg)
	DDX_Text(pDX, IDC_FULL_ADDRESS, m_Full_Address);
	DDX_Text(pDX, IDC_RANGE, m_Range);
	DDX_Text(pDX, IDC_STREET, m_Street);
	DDX_Text(pDX, IDC_PRE_DIR, m_Pre_Dir);
	DDX_Text(pDX, IDC_POST_DIR, m_Post_Dir);
	DDX_Text(pDX, IDC_SUFFIX, m_Suffix);
	DDX_Text(pDX, IDC_STE_NAME, m_Suite_Name);
	DDX_Text(pDX, IDC_STE_NUM, m_Suite_Number);
	DDX_Text(pDX, IDC_BUILD_NUM, m_Build_Number);
	DDX_Text(pDX, IDC_GARBAGE, m_Garbage);
	DDX_Text(pDX, IDC_LAST_LINE, m_Last_Line);
	DDX_Text(pDX, IDC_CITY, m_City);
	DDX_Text(pDX, IDC_PLUS4, m_Plus4);
	DDX_Text(pDX, IDC_STATE, m_State);
	DDX_Text(pDX, IDC_ZIP, m_Zip);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CParseDlg, CDialog)
	//{{AFX_MSG_MAP(CParseDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PARSE, OnParse)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_REPARSE, OnReparse)
	ON_BN_CLICKED(IDC_LLPARSE, OnLlparse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CParseDlg message handlers
BOOL CParseDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CComBSTR retStr;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	//ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	//ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	try
	{
		// New COM - AddressCoder Object - Parse interface
		parse = new IParsePtr(__uuidof(Parse));

		parseCreated = true;
		// Copy Build Info to Dialogue and set initial values.
		UpdateData();
		retStr = (LPCOLESTR)parse->GetBuildNumber();
		m_Build_Number = retStr.Detach();
		m_Full_Address = "201 10th. Street";
		m_Last_Line="Las Vegas, NV 89101";

		UpdateData(false);

	}
	catch(const _com_error &e)
	{
		AfxMessageBox(e.ErrorMessage());
	}


	return TRUE;  // return TRUE  unless you set the focus to a control
}
void CParseDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		//CAboutDlg dlgAbout;
		//dlgAbout.DoModal();
		int x=0;
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

//  If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CParseDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}
// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CParseDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CParseDlg::OnParse()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;

	//Copy Input Address to BSTR
	_bstr_t passVal((LPCTSTR)m_Full_Address);

	//Check initial parsing, returning 0 means failure
	if(parse->Parse(passVal) != 1)
	{
		//Failure, show message
		AfxMessageBox("Failed to Parse Address.");
		return;
	}
	else
	{
		//Success, Copy data to Dialogue
		//Allow Dialogue update
		UpdateData();
		retStr = (LPCOLESTR)parse->GetRange();
		m_Range = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetStreetName();
		m_Street = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetPreDirection();
		m_Pre_Dir = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetPostDirection();
		m_Post_Dir = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuffix();
		m_Suffix = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuiteName();
		m_Suite_Name = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuiteNumber();
		m_Suite_Number = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetGarbage();
		m_Garbage = retStr.Detach();

		UpdateData(FALSE);
	}

}

void CParseDlg::OnClear()
{
	//This will fill the display with blanks
	m_Full_Address.Empty();
	m_Range.Empty();
	m_Street.Empty();
	m_Pre_Dir.Empty();
	m_Post_Dir.Empty();
	m_Suffix.Empty();
	m_Suite_Name.Empty();
	m_Suite_Number.Empty();
	m_Garbage.Empty();


	UpdateData(FALSE);

}

void CParseDlg::OnReparse()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;

	//Check initial parsing, returning 0 means failure
	if(parse->ParseNext() == 0)
	{
		//Failure, display message, no more parsing available.
		AfxMessageBox("There are no more Reparses.");
		return;
	}
	else
	{
		//Success, Copy data to Dialogue
		//Allow Dialogue update
		UpdateData();
		retStr = (LPCOLESTR)parse->GetRange();
		m_Range = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetStreetName();
		m_Street = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetPreDirection();
		m_Pre_Dir = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetPostDirection();
		m_Post_Dir = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuffix();
		m_Suffix = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuiteName();
		m_Suite_Name = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetSuiteNumber();
		m_Suite_Number = retStr.Detach();

		retStr = (LPCOLESTR)parse->GetGarbage();
		m_Garbage = retStr.Detach();
		UpdateData(FALSE);

	}

}

void CParseDlg::OnCancel()
{

	CDialog::OnCancel();
}

void CParseDlg::OnLlparse()
{
	//Needed to handle the BSTR's
	CComBSTR retStr;


	//Copy Input Lastline to BSTR
	_bstr_t passVal((LPCTSTR)m_Last_Line);

	//Call LastLineParse()
	parse->LastLineParse(passVal);

	//Allow Dialogue update
	UpdateData();
	retStr = (LPCOLESTR)parse->GetCity();
	m_City = retStr.Detach();

	retStr = (LPCOLESTR)parse->GetState();
	m_State = retStr.Detach();

	retStr = (LPCOLESTR)parse->GetZip();
	m_Zip = retStr.Detach();

	retStr = (LPCOLESTR)parse->GetPlus4();
	m_Plus4 = retStr.Detach();

	UpdateData(FALSE);

}
